import React from "react";
import { Button, IconButton, Stack, Typography } from "@mui/material";
import { CustomStackFullWidth } from "../../../styled-components/CustomStyles.style";
import SearchIcon from "@mui/icons-material/Search";
import CloseIcon from "@mui/icons-material/Close";
import HistoryIcon from '@mui/icons-material/History';

const RecentSearches = ({
  list,
  t,
  handleSearchHistoryOnClick,
  handleDeleteAble,
  clearAll,
}) => {
  return (
    <Stack>
      <Stack direction="row" justifyContent="space-between">
        <Typography
          sx={{
            my: "10px",
            color: (theme) => theme.palette.neutral[500],
            fontSize: "1rem",
          }}
        >
          {t("Recent Searches")}
        </Typography>
        <Button onClick={clearAll} sx={{color:theme=>theme.palette.error.main,fontWeight:"400"}}>{t("Clear All")}</Button>
      </Stack>
      <CustomStackFullWidth>
        {list
          .slice(0, 5)
          .reverse()
          .map((item, index) => {
            return (
              <CustomStackFullWidth
                direction="row"
                alignItems="center"
                justifyContent="space-between"
                key={index}
              >
                <Stack
                  direction="row"
                  alignItems="center"
                  onClick={() => handleSearchHistoryOnClick(item)}
                  sx={{ cursor: "pointer" }}
                  spacing={0.5}
                >
                  <HistoryIcon sx={{ fontSize: "18px" }} />
                  <Typography
                    sx={{ color: (theme) => theme.palette.neutral[700] }}
                  >
                    {item}
                  </Typography>
                </Stack>
                <IconButton sx={{ borderRadius: "50%" }}>
                  <CloseIcon
                    onClick={() => handleDeleteAble(item)}
                    sx={{
                      color: (theme) => theme.palette.neutral[400],
                      fontSize: "18px",
                    }}
                  />
                </IconButton>
              </CustomStackFullWidth>
            );
          })}
      </CustomStackFullWidth>
    </Stack>
  );
};

export default RecentSearches;
